'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_20_vorwaerts_Click()
    Dim rst As Recordset
    Dim i As Integer
    Set rst = Me.RecordsetClone
    rst.Bookmark = Me.Bookmark
    For i = 1 To 20
        rst.MoveNext
        If rst.EOF Then Exit For
    Next i
    If rst.EOF Then
        rst.MoveLast
        Me.Bookmark = rst.Bookmark
        If Me.Button_rueckwaerts.Enabled = False Then         'Focus umsetzen, bevor Element de-aktiviert wird
            Me.gilt_ab.SetFocus
        Else
            Me.Button_rueckwaerts.SetFocus
        End If
        Me.Button_vorwaerts.Enabled = False
        Me.Button_LetzterDatensatz.Enabled = False
        Me.Button_20_vorwaerts.Enabled = False
        If i > 1 Then
            Me.Button_rueckwaerts.Enabled = True
            Me.Button_ErsterDatensatz.Enabled = True
            Me.Button_20_zurueck.Enabled = True
            Me.Button_rueckwaerts.SetFocus
        End If
    Else
        'Button fr Gegenrichtung freigeben
        Me.Button_rueckwaerts.Enabled = True
        Me.Button_ErsterDatensatz.Enabled = True
        Me.Button_20_zurueck.Enabled = True
        'Datensatz ins Formular holen
        Me.Bookmark = rst.Bookmark
        'Button fr die nchste Aktion vorbereiten(!)
        rst.MoveNext
        If rst.EOF Then
            Me.Button_rueckwaerts.SetFocus          'Focus umsetzen, bevor Element de-aktiviert wird
            Me.Button_vorwaerts.Enabled = False
            Me.Button_LetzterDatensatz.Enabled = False
            Me.Button_20_vorwaerts.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Button_20_zurueck_Click()
    Dim rst As Recordset
    Dim i As Integer
    Set rst = Me.RecordsetClone
    rst.Bookmark = Me.Bookmark
    For i = 1 To 20
        rst.MovePrevious
        If rst.BOF Then Exit For
    Next i
    If rst.BOF Then
        rst.MoveFirst
        Me.Bookmark = rst.Bookmark
        If Me.Button_vorwaerts.Enabled = False Then         'Focus umsetzen, bevor Element de-aktiviert wird
            Me.gilt_ab.SetFocus
        Else
            Me.Button_vorwaerts.SetFocus
        End If
        Me.Button_rueckwaerts.Enabled = False
        Me.Button_ErsterDatensatz.Enabled = False
        Me.Button_20_zurueck.Enabled = False
        If i > 1 Then
            Me.Button_vorwaerts.Enabled = True
            Me.Button_LetzterDatensatz.Enabled = True
            Me.Button_20_vorwaerts.Enabled = True
            Me.Button_vorwaerts.SetFocus
        End If
    Else
        'Button fr Gegenrichtung freigeben
        Me.Button_vorwaerts.Enabled = True
        Me.Button_LetzterDatensatz.Enabled = True
        Me.Button_20_vorwaerts.Enabled = True
        'Datensatz ins Formular holen
        Me.Bookmark = rst.Bookmark
        'Button fr die nchste Aktion vorbereiten(!)
        rst.MovePrevious
        If rst.BOF Then
            Me.Button_vorwaerts.SetFocus          'Focus umsetzen, bevor Element de-aktiviert wird
            Me.Button_rueckwaerts.Enabled = False
            Me.Button_ErsterDatensatz.Enabled = False
            Me.Button_20_vorwaerts.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Button_Abbruch_Click()
On Error GoTo Err_Button_Abbruch_Click


    DoCmd.Close

Exit_Button_Abbruch_Click:
    Exit Sub

Err_Button_Abbruch_Click:
    MsgBox err.Description
    Resume Exit_Button_Abbruch_Click
    
End Sub

Private Sub Button_ErsterDatensatz_Click()
    Dim rst As Recordset
    Set rst = Me.RecordsetClone
    rst.Bookmark = Me.Bookmark
    rst.MoveFirst
    If rst.BOF Then
        If Me.Button_vorwaerts.Enabled = False Then         'Focus umsetzen, bevor Element de-aktiviert wird
            Me.gilt_ab.SetFocus
        Else
            Me.Button_vorwaerts.SetFocus
        End If
        Me.Button_rueckwaerts.Enabled = False
        Me.Button_ErsterDatensatz.Enabled = False
        Me.Button_20_zurueck.Enabled = False
    Else
        'Button fr Gegenrichtung freigeben
        Me.Button_vorwaerts.Enabled = True
        Me.Button_LetzterDatensatz.Enabled = True
        Me.Button_20_vorwaerts.Enabled = True
        Me.Button_vorwaerts.SetFocus
        'Datensatz ins Formular holen
        Me.Bookmark = rst.Bookmark
        'Button fr die nchste Aktion vorbereiten(!)
        rst.MovePrevious
        If rst.BOF Then
            Me.Button_vorwaerts.SetFocus          'Focus umsetzen, bevor Element de-aktiviert wird
            Me.Button_rueckwaerts.Enabled = False
            Me.Button_ErsterDatensatz.Enabled = False
            Me.Button_20_zurueck.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Button_LetzterDatensatz_Click()
    Dim rst As Recordset
    Set rst = Me.RecordsetClone
    rst.Bookmark = Me.Bookmark
    rst.MoveLast
    If rst.EOF Then
        If Me.Button_rueckwaerts.Enabled = False Then         'Focus umsetzen, bevor Element de-aktiviert wird
            Me.gilt_ab.SetFocus
        Else
            Me.Button_rueckwaerts.SetFocus
        End If
        Me.Button_vorwaerts.Enabled = False
        Me.Button_LetzterDatensatz.Enabled = False
        Me.Button_20_vorwaerts.Enabled = False
    Else
        'Button fr Gegenrichtung freigeben
        Me.Button_rueckwaerts.Enabled = True
        Me.Button_ErsterDatensatz.Enabled = True
        Me.Button_20_zurueck.Enabled = True
        Me.Button_rueckwaerts.SetFocus
        'Datensatz ins Formular holen
        Me.Bookmark = rst.Bookmark
        'Button fr die nchste Aktion vorbereiten(!)
        rst.MoveNext
        If rst.EOF Then
            Me.Button_rueckwaerts.SetFocus          'Focus umsetzen, bevor Element de-aktiviert wird
            Me.Button_vorwaerts.Enabled = False
            Me.Button_LetzterDatensatz.Enabled = False
            Me.Button_20_vorwaerts.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Button_OK_Click()

    'Variablen deklarieren
    Dim dbs As Database
    Dim rst As Recordset
    Dim rstPreise As Recordset
    Dim rstWahl As Recordset
    Dim FilterPreis As String
    Dim Datum As Date
    Dim Preis As Currency
    Dim x As Integer
    Dim y As Integer
    Dim txt As String
    
    
    'Gltigkeitsprfungen
    If (IsNull(Me.gilt_ab.Value) Or (Trim(Me.gilt_ab.Value) = "")) Then
        MsgBox "Bitte geben Sie ein Gilt-ab-Datum ein!", vbCritical, "Fehler"
        Me.gilt_ab.SetFocus
        Exit Sub
    End If
    If Not IsDate(Me.gilt_ab.Value) Then
        MsgBox "Bitte geben Sie ein gltiges Gilt-ab-Datum ein!", vbCritical, "Fehler"
        Me.gilt_ab.SetFocus
        Exit Sub
    End If
    If (IsNull(Me.Stundensatz.Value) Or (Trim(Me.Stundensatz.Value) = "")) Then
        MsgBox "Bitte geben Sie einen Stundensatz ein!", vbCritical, "Fehler"
        Me.Stundensatz.SetFocus
        Exit Sub
    End If
            
    'Hinweis zum Warten anzeigen
    'DoCmd.OpenForm "Bitte_warten"
    'Forms![Bitte_warten].Repaint
    
    If MsgBox("Soll der Preis zu den ausgewhlten Elementen wirklich gespeichert werden?", vbYesNo + vbQuestion + vbDefaultButton2, "Preis speichern...") = vbNo Then
        Exit Sub
    End If
    
    
    'evtl. Bearbeitungsmodus des Unterformulars beenden und nderung speichern
    If Me.Mehrfachwahl_UF1.Form.Dirty = True Then Me.Mehrfachwahl_UF1.Form.Requery
    
    'Werte aus der Maske zwischenspeichern
    Datum = Me.gilt_ab.Value
    Preis = Me.Stundensatz.Value
    
    x = 0       'fr NEU
    y = 0       'fr UPDATE
    
    Set dbs = CurrentDb
    
    'Mehrfachwahl-Tabelle durchgehen und den Preis in alle angehakten Kombinationen bernehmen
    Set rstWahl = dbs.OpenRecordset("SELECT * FROM Mehrfachwahl WHERE Auswahl = True")
    If rstWahl.RecordCount > 0 Then
        rstWahl.MoveLast    'auffllen
        rstWahl.MoveFirst
        Do While Not rstWahl.EOF
            
            'Filterzeichenkette vorbereiten
            FilterPreis = "SELECT * FROM Preise WHERE" & _
                " gilt_ab = #" & Month(Datum) & "/" & Day(Datum) & "/" & Year(Datum) & "# AND " & _
                " lfd_Nr_Kunde = " & SatzKontaktDummy & " AND " & _
                " lfd_Nr_Kalender = " & rstWahl!Tab1_lfd_Nr & " AND " & _
                " lfd_Nr_Kategorie = " & rstWahl!Tab2_lfd_Nr
            
            'Nach Preis-Eintrag filtern
            Set rstPreise = dbs.OpenRecordset(FilterPreis)
            If rstPreise.RecordCount > 0 Then
                'einen vorhandenen Preis ndern...
                rstPreise.MoveLast  'auffllen
                rstPreise.MoveFirst
                rstPreise.Edit
                    'rstPreise!gilt_ab = Datum
                    rstPreise!Std_Satz = Preis
                    'rstPreise!Jahr = Year(Datum)
                    'rstPreise!Monat = Month(Datum)
                    'rstPreise!Tag = Day(Datum)
                    'rstPreise!lfd_Nr_Kunde = SatzKontaktDummy
                    rstPreise!lfd_Nr_Kalender = rstWahl!Tab1_lfd_Nr
                    rstPreise!lfd_Nr_Kategorie = rstWahl!Tab2_lfd_Nr
                rstPreise.Update
                y = y + 1
            Else
                'neuen Preiseintrag anlegen...
                rstPreise.AddNew
                    rstPreise!gilt_ab = Datum
                    rstPreise!Std_Satz = Preis
                    rstPreise!Jahr = Year(Datum)
                    rstPreise!Monat = Month(Datum)
                    rstPreise!Tag = Day(Datum)
                    rstPreise!lfd_Nr_Kunde = SatzKontaktDummy
                    rstPreise!lfd_Nr_Kalender = rstWahl!Tab1_lfd_Nr
                    rstPreise!lfd_Nr_Kategorie = rstWahl!Tab2_lfd_Nr
                rstPreise.Update
                x = x + 1
            End If
            rstPreise.Close
            
            rstWahl.MoveNext
        Loop
    End If
    rstWahl.Close
    
    'Mitteilung ber Preisnderungen
    If (x > 0) Or (y > 0) Then
        Select Case x
            Case 0
                txt = "Neue Preise: 0" & vbNewLine
            Case 1
                txt = "Neuer Preis: 1" & vbNewLine
            Case Is > 1
                txt = "Neue Preise: " & x & vbNewLine
        End Select
        Select Case y
            Case 0
                txt = txt & "Genderte Preise: 0"
            Case 1
                txt = txt & "Genderter Preis: 1"
            Case Is > 1
                txt = txt & "Genderte Preise: " & y
        End Select
        MsgBox txt, vbOKOnly + vbInformation, "Fertig!"
    End If
    
    
    
    
ExitGebuehrAnlegen:
    
    On Error Resume Next

    'sich selbst schlieen
    DoCmd.Close acForm, "Mehrfachwahl_PreisNeu", acSaveYes
    
    Exit Sub
    
    
ErrorGebhrAnlegenFehler:
        MsgBox "Beim Speichern der Gebhr trat ein Fehler auf!", vbCritical, "Fehler"
        MsgBox err.Description
        Resume ExitGebuehrAnlegen

End Sub

Private Sub Button_rueckwaerts_Click()
    Dim rst As Recordset
    Set rst = Me.RecordsetClone
    rst.Bookmark = Me.Bookmark
    rst.MovePrevious
    If rst.BOF Then
        If Me.Button_vorwaerts.Enabled = False Then         'Focus umsetzen, bevor Element de-aktiviert wird
            Me.gilt_ab.SetFocus
        Else
            Me.Button_vorwaerts.SetFocus
        End If
        Me.Button_rueckwaerts.Enabled = False
        Me.Button_ErsterDatensatz.Enabled = False
        Me.Button_20_zurueck.Enabled = False
    Else
        'Button fr Gegenrichtung freigeben
        Me.Button_vorwaerts.Enabled = True
        Me.Button_LetzterDatensatz.Enabled = True
        Me.Button_20_vorwaerts.Enabled = True
        'Datensatz ins Formular holen
        Me.Bookmark = rst.Bookmark
        'Button fr die nchste Aktion vorbereiten(!)
        rst.MovePrevious
        If rst.BOF Then
            Me.Button_vorwaerts.SetFocus          'Focus umsetzen, bevor Element de-aktiviert wird
            Me.Button_rueckwaerts.Enabled = False
            Me.Button_ErsterDatensatz.Enabled = False
            Me.Button_20_zurueck.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Button_vorwaerts_Click()
    Dim rst As Recordset
    Set rst = Me.RecordsetClone
    rst.Bookmark = Me.Bookmark
    rst.MoveNext
    If rst.EOF Then
        If Me.Button_rueckwaerts.Enabled = False Then         'Focus umsetzen, bevor Element de-aktiviert wird
            Me.gilt_ab.SetFocus
        Else
            Me.Button_rueckwaerts.SetFocus
        End If
        Me.Button_vorwaerts.Enabled = False
        Me.Button_LetzterDatensatz.Enabled = False
        Me.Button_20_vorwaerts.Enabled = False
    Else
        'Button fr Gegenrichtung freigeben
        Me.Button_rueckwaerts.Enabled = True
        Me.Button_ErsterDatensatz.Enabled = True
        Me.Button_20_zurueck.Enabled = True
        'Datensatz ins Formular holen
        Me.Bookmark = rst.Bookmark
        'Button fr die nchste Aktion vorbereiten(!)
        rst.MoveNext
        If rst.EOF Then
            Me.Button_rueckwaerts.SetFocus          'Focus umsetzen, bevor Element de-aktiviert wird
            Me.Button_vorwaerts.Enabled = False
            Me.Button_LetzterDatensatz.Enabled = False
            Me.Button_20_vorwaerts.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Form_Current()
    Call Zaehler_in_Merfachwahl_PreisNeu_aktualisieren
End Sub

Private Sub Form_Load()
    On Error Resume Next
'    DoCmd.Close acForm, "Kategorien", acSaveYes
'    DoCmd.Close acForm, "Kunden", acSaveYes
'    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    Dim dbs As Database
    Dim rst As Recordset        'Kalender
    Dim rst2 As Recordset       'Kategorien
    Dim rst3 As Recordset       'Mehrfachwahl
    Dim FilterPreis As String
    Dim rstPreise As Recordset
    
    Dim KalenderNull As Integer 'fr Spezialfall: OHNE Kalender, NUR Kategorien
    
    Set dbs = CurrentDb
    
    'Mehrfachwahl-Tabelle initialisieren
    Set rst3 = dbs.OpenRecordset("SELECT * FROM Mehrfachwahl")
    'erst alles Lschen...
    If rst3.RecordCount > 0 Then
        rst3.MoveLast    'auffllen
        Do While rst3.RecordCount > 0
            rst3.MoveFirst
            rst3.Delete
        Loop
    End If
    'dann mit allen Kombinationen aus Kalender und Kategorie fllen...
    KalenderNull = 0
    Set rst = dbs.OpenRecordset("SELECT lfd_Nr, Name FROM Kalender ORDER BY Name")
    Set rst2 = dbs.OpenRecordset("SELECT lfd_Nr, Name1 FROM Kategorien ORDER BY Name1")
    Set rst3 = dbs.OpenRecordset("SELECT * FROM Mehrfachwahl")
    If rst.RecordCount > 0 Then
        rst.MoveLast    'auffllen
        rst.MoveFirst
        Do While Not rst.EOF
            If rst2.RecordCount > 0 Then
                rst2.MoveLast   'auffllen
                rst2.MoveFirst
                Do While Not rst2.EOF
                    'Wenn Kalender UND Kategorie ausgewhlt sind, dann
                    'Dummy-Kategorie und Kalender_0 ausklammern!
                    'bei "NurKalender" und "NurKategorien" den Dummy des
                    'jeweils 'bergeordneten' aufnehmen
                    Select Case Mehrfachwahl_Primaer
                        Case "Kalender", "Kategorie"
                            If (rst2!lfd_Nr <> SatzKategorieDummy) And (KalenderNull <> 0) Then
                                rst3.AddNew
                                rst3!Tab1_lfd_Nr = rst!lfd_Nr       'Kalender
                                rst3!Tab2_lfd_Nr = rst2!lfd_Nr      'Kategorie
                                rst3!Tab1_Name = rst!Name           'Kalenderbezeichnung
                                rst3!Tab2_Name = rst2!Name1         'Kategoriebezeichnung
                                rst3!Auswahl = False                'keine Auswahl
                                rst3!Betrag = -999999.99            'kein Betrag
                                rst3!Datum = #1/1/2001#             'noch kein Gilt-ab_Datum
                                rst3!Preis = -999999.99             'noch kein Preis
                                rst3.Update
                            End If
                        Case "NurKalender"
                            If (rst2!lfd_Nr = SatzKategorieDummy) And (KalenderNull <> 0) Then
                                rst3.AddNew
                                rst3!Tab1_lfd_Nr = rst!lfd_Nr       'Kalender
                                rst3!Tab2_lfd_Nr = rst2!lfd_Nr      'Kategorie (...-Dummy)
                                rst3!Tab1_Name = rst!Name           'Kalenderbezeichnung
                                rst3!Tab2_Name = rst2!Name1         'Kategoriebezeichnung
                                rst3!Auswahl = False                'keine Auswahl
                                rst3!Betrag = -999999.99            'kein Betrag
                                rst3!Datum = #1/1/2001#             'noch kein Gilt-ab_Datum
                                rst3!Preis = -999999.99             'noch kein Preis
                                rst3.Update
                            End If
                        Case "NurKategorien"
                            If (KalenderNull = 0) And (rst2!lfd_Nr <> SatzKategorieDummy) Then
                                rst3.AddNew
                                rst3!Tab1_lfd_Nr = 0            'KalenderDummy
                                rst3!Tab2_lfd_Nr = rst2!lfd_Nr      'Kategorie
                                rst3!Tab1_Name = "(alle Kalender)"
                                rst3!Tab2_Name = rst2!Name1         'Kategoriebezeichnung
                                rst3!Auswahl = False                'keine Auswahl
                                rst3!Betrag = -999999.99            'kein Betrag
                                rst3!Datum = #1/1/2001#             'noch kein Gilt-ab_Datum
                                rst3!Preis = -999999.99             'noch kein Preis
                                rst3.Update
                            End If
                    End Select
                    rst2.MoveNext
                Loop
            End If
            'Kalendereintrge erst durchgehen, wenn Kalender "0" bearbeitet
            If KalenderNull = 0 Then
                KalenderNull = 1
            Else
                rst.MoveNext
            End If
        Loop
    End If
    rst.Close
    rst2.Close
    rst3.Close
    
    'aktuellsten gltigen Preis bernehmen
    Set rst3 = dbs.OpenRecordset("SELECT * FROM Mehrfachwahl")
    If rst3.RecordCount > 0 Then
        rst3.MoveLast       'auffllen
        rst3.MoveFirst
        Do While Not rst3.EOF
            'Filterzeichenkette vorbereiten
            FilterPreis = "SELECT * FROM Preise WHERE" & _
                " lfd_Nr_Kunde = " & SatzKontaktDummy & " AND " & _
                " lfd_Nr_Kalender = " & rst3!Tab1_lfd_Nr & " AND " & _
                " lfd_Nr_Kategorie = " & rst3!Tab2_lfd_Nr & _
                " ORDER BY gilt_ab DESC"
            'Nach Preis-Eintrag filtern
            Set rstPreise = dbs.OpenRecordset(FilterPreis)
            If rstPreise.RecordCount > 0 Then
                'einen vorhandenen Preis ndern...
                rstPreise.MoveLast  'auffllen
                rstPreise.MoveFirst
                rst3.Edit
                    rst3!Datum = rstPreise!gilt_ab
                    rst3!Preis = rstPreise!Std_Satz
                rst3.Update
            End If
            
            'nchster Datensatz
            rst3.MoveNext
        Loop
    End If
    rst3.Close
    
    'Richtige Primrquelle festlegen und richtige Synchronisation des Unterformulars einstellen
    'und berschriften-Anzeige einstellen
    Select Case Mehrfachwahl_Primaer
        Case "Kalender"
            Me.RecordSource = "SELECT lfd_Nr, Name FROM Kalender ORDER BY Name"
            Me.Mehrfachwahl_UF1.LinkChildFields = "Tab1_lfd_Nr"     'linke Seite der Tabelle "Mehrfachwahl" (Kalender)
            Me.Mehrfachwahl_UF1.Form.OrderBy = "Tab2_Name"          'rechte Seite der Maske nach Kategoriename sortieren
            Me.Mehrfachwahl_UF1.Form.Filter = ""
            Me.Mehrfachwahl_UF1.Form.Requery
            Me.Text_NamePrimaer.Visible = True
            Me.Text_NameOhnePrimaer.Visible = False
            Me.Caption = "Neuer Preis fr Kalender/Kategorie"
        Case "Kategorie"
            Me.RecordSource = "SELECT lfd_Nr, Name1 as Name FROM Kategorien WHERE lfd_Nr <> " & SatzKategorieDummy & " ORDER BY Name1"
            Me.Mehrfachwahl_UF1.LinkChildFields = "Tab2_lfd_Nr"     'rechte Seite der Tabelle "Mehrfachwahl" (Kategorie)
            Me.Mehrfachwahl_UF1.Form.OrderBy = "Tab1_Name"          'rechte Seite der Maske nach Kalendername sortieren
            Me.Mehrfachwahl_UF1.Form.Filter = ""
            Me.Mehrfachwahl_UF1.Form.Requery
            Me.Text_NamePrimaer.Visible = True
            Me.Text_NameOhnePrimaer.Visible = False
            Me.Caption = "Neuer Preis fr Kategorie/Kalender"
        Case "NurKalender"
            Me.RecordSource = "SELECT lfd_Nr, Name1 as Name FROM Kategorien WHERE lfd_Nr = " & SatzKategorieDummy & " ORDER BY Name1"
            Me.Mehrfachwahl_UF1.LinkChildFields = "Tab2_lfd_Nr"     'rechte Seite der Tabelle "Mehrfachwahl" (Kategorie)
            Me.Mehrfachwahl_UF1.Form.OrderBy = "Tab1_Name"          'rechte Seite der Maske nach Kalendername sortieren
            Me.Mehrfachwahl_UF1.Form.Filter = ""
            Me.Mehrfachwahl_UF1.Form.Requery
            Me.Text_NamePrimaer.Visible = False
            Me.Text_NameOhnePrimaer.Visible = True
            Me.Text_NameOhnePrimaer.Caption = "(alle Kategorien)"
            Me.Caption = "Neuer Preis fr Kalender"
        Case "NurKategorien"
            'Me.RecordSource = "SELECT lfd_Nr, Name FROM Kalender ORDER BY Name"
            Me.RecordSource = "SELECT Tab1_lfd_Nr as lfd_Nr FROM Mehrfachwahl"
            Me.Mehrfachwahl_UF1.LinkChildFields = "Tab1_lfd_Nr"     'linke Seite der Tabelle "Mehrfachwahl" (Kalender)
            Me.Mehrfachwahl_UF1.Form.OrderBy = "Tab2_Name"          'rechte Seite der Maske nach Kategoriename sortieren
            Me.Mehrfachwahl_UF1.Form.Filter = ""
            Me.Mehrfachwahl_UF1.Form.Requery
            Me.Text_NamePrimaer.Visible = False
            Me.Text_NameOhnePrimaer.Visible = True
            Me.Text_NameOhnePrimaer.Caption = "(alle Kalender)"
            Me.Caption = "Neuer Preis fr Kategorien"
    End Select
    
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.Stundensatz.Format = "Currency"
    
    Me.gilt_ab.InputMask = "00/00/0099;0;_"
    
    'Vorwrts-/Rckwrts-Button initialisieren
    Set rst = Me.RecordsetClone
    If rst.RecordCount <= 1 Then
        'nur 1 oder kein Datensatz = keine Navigation mglich
        Me.Button_vorwaerts.Enabled = False
        Me.Button_rueckwaerts.Enabled = False
        Me.Button_ErsterDatensatz.Enabled = False
        Me.Button_LetzterDatensatz.Enabled = False
        Me.Button_20_vorwaerts.Enabled = False
        Me.Button_20_zurueck.Enabled = False
    Else
        'mindestens 2 oder mehr Datenstze
        rst.MovePrevious
        If rst.BOF Then
            Me.Button_rueckwaerts.Enabled = False
            Me.Button_ErsterDatensatz.Enabled = False
            Me.Button_20_zurueck.Enabled = False
        End If
    End If
    rst.Close
End Sub

Private Sub Gilt_ab_LostFocus()
    Dim dbs As Database
    Dim rst As Recordset
    Dim rst2 As Recordset
    Dim txt As String
    Dim txt2 As String
    Dim dat As Date
    
    Set dbs = CurrentDb
    
    'Mehrfachwahl-Tabelle zunchst zurcksetzen
    Set rst = dbs.OpenRecordset("SELECT Betrag FROM Mehrfachwahl")
    If rst.RecordCount > 0 Then
        rst.MoveLast        'auffllen
        rst.MoveFirst
        Do While Not rst.EOF
            rst.Edit
            rst!Betrag = -999999.99
            rst.Update
            rst.MoveNext
        Loop
    End If
    rst.Close
    
    'Preis-Tabelle durchgehen und mit der Mehrfachwahl-Tabelle abgleichen
    'wenn Gilt-ab_Datum und Kalender und Kategorie identisch, Preis zur Information bernehmen
    If IsDate(Me.gilt_ab.Value) Then
        dat = Me.gilt_ab.Value
        txt = "SELECT * FROM Preise WHERE " & _
                    " gilt_ab = #" & Month(dat) & "/" & Day(dat) & "/" & Year(dat) & "# AND " & _
                    " lfd_Nr_Kunde = " & SatzKontaktDummy
        Set rst = dbs.OpenRecordset(txt)
        If rst.RecordCount > 0 Then
            rst.MoveLast        'auffllen
            rst.MoveFirst
            Do While Not rst.EOF
                txt2 = "SELECT * FROM Mehrfachwahl WHERE Tab1_lfd_Nr=" & rst!lfd_Nr_Kalender & " AND Tab2_lfd_Nr=" & rst!lfd_Nr_Kategorie
                Set rst2 = dbs.OpenRecordset(txt2)
                If rst2.RecordCount > 0 Then
                    rst2.MoveFirst
                    'Betrag in Mehrfachwahl-Tabelle bernehmen
                    rst2.Edit
                    rst2!Betrag = rst!Std_Satz
                    rst2.Update
                End If
                rst2.Close
                rst.MoveNext
            Loop
        End If
        rst.Close
    End If
    
    'Zhler im Unterformular aktualisieren
    Call Form_Current
    
End Sub

Private Sub Stundensatz_Exit(Cancel As Integer)
    If (IsNull(Me.Stundensatz.Value) Or (Trim(Me.Stundensatz.Value) = "")) Then Exit Sub
    Me.Stundensatz.Value = Format(Me.Stundensatz.Value, "#,##0.0000")
End Sub
